<?php
$templates_sql = "";
$setup_sql = "
DROP TABLE IF EXISTS `".DB_PREFIX."access_log`; 
CREATE TABLE `".DB_PREFIX."access_log` (
  `id` int(11) NOT NULL auto_increment,
  `ip` varchar(128) NOT NULL,
  `user_agent` varchar(191) NOT NULL,
  `action` varchar(191) NOT NULL,
  `data` text NOT NULL,
  `admin_id` int(11) NOT NULL,
  `created_at` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  PRIMARY KEY  (`id`),
  KEY action (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."act_list`; 
CREATE TABLE `".DB_PREFIX."act_list` (
  `mid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned NOT NULL,
  `date` date NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."act_stat`; 
CREATE TABLE `".DB_PREFIX."act_stat` (
  `aid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned NOT NULL,
  `stat` datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  `date` int(11) unsigned NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `_ID` int(11) unsigned NOT NULL,
  `statid` int(11) unsigned NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  UNIQUE KEY `id` (`id`),
  KEY date (`date`),
  KEY aid (`aid`),
  KEY aid_2 (`aid`,`uid`),
  KEY aid_3 (`aid`,`stat`),
  KEY mid (`mid`),
  KEY statid (`statid`),
  KEY statid_2 (`statid`,`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."actions`; 
CREATE TABLE `".DB_PREFIX."actions` (
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `url1` varchar(255),
  `url2` varchar(255) NOT NULL,
  `url1_text` mediumtext NOT NULL,
  `url2_text` mediumtext NOT NULL,
  `start` date NOT NULL,
  `end` date NOT NULL,
  `copy` mediumtext NOT NULL,
  `del` mediumtext NOT NULL,
  `urlap` mediumtext NOT NULL,
  `admin` tinyint(1) NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `timed_mail_date` date NOT NULL,
  `s_mail` smallint(5) unsigned,
  `date` date,
  `xday` mediumint(8) unsigned NOT NULL,
  `click` mediumint(8) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `inact` mediumtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."ban`; 
CREATE TABLE `".DB_PREFIX."ban` (
  `id` int(11) NOT NULL auto_increment,
  `ip` varchar(255) NOT NULL,
  `created_at` timestamp DEFAULT current_timestamp() NOT NULL,
  PRIMARY KEY  (`id`),
  KEY ip (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."blacklist`; 
CREATE TABLE `".DB_PREFIX."blacklist` (
  `word` varchar(255) NOT NULL,
  `run` bigint(20) unsigned NOT NULL,
  `date` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `g` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."bounce_account`; 
CREATE TABLE `".DB_PREFIX."bounce_account` (
  `id` int(11) NOT NULL auto_increment,
  `domain` varchar(255) NOT NULL,
  `bounce_mail` varchar(255) NOT NULL,
  `pop3_host` varchar(255) NOT NULL,
  `pop3_port` smallint(6),
  `pop3_user` varchar(255) NOT NULL,
  `pop3_password` varchar(255) NOT NULL,
  `pop3_tls` tinyint(4) NOT NULL,
  `last_run` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."bounce_mails`; 
CREATE TABLE `".DB_PREFIX."bounce_mails` (
  `mail` varchar(255) NOT NULL,
  `s` tinyint(1) unsigned,
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `error` mediumint(8) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `info` text NOT NULL,
  `send_date` datetime NOT NULL,
  `info_sub` varchar(128) NOT NULL,
  `bounce_account_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY info_sub (`info_sub`),
  KEY mail (`mail`,`error`),
  KEY bounce_account_id (`bounce_account_id`),
  KEY date (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."campaigns`; 
CREATE TABLE `".DB_PREFIX."campaigns` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `params` longtext,
  `created_at` timestamp DEFAULT current_timestamp() NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."config`; 
CREATE TABLE `".DB_PREFIX."config` (
  `wg_conf` varchar(255),
  `conf_value` mediumtext,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."cyclic`; 
CREATE TABLE `".DB_PREFIX."cyclic` (
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `filter` int(11) unsigned NOT NULL,
  `hour` tinyint(3) unsigned NOT NULL,
  `month` tinyint(3) unsigned NOT NULL,
  `week` tinyint(3) unsigned NOT NULL,
  `day` smallint(5) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."down_stat`; 
CREATE TABLE `".DB_PREFIX."down_stat` (
  `uid` int(11) unsigned NOT NULL,
  `fid` int(11) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `filestat_ID` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`filestat_ID`),
  KEY uid (`uid`,`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."fields`; 
CREATE TABLE `".DB_PREFIX."fields` (
  `g` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `check` tinyint(1) NOT NULL,
  `hidden` tinyint(1) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `hely` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `default` text NOT NULL,
  `modifiable` tinyint(4) DEFAULT '1' NOT NULL,
  `option` tinyint(4) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."fields_data`; 
CREATE TABLE `".DB_PREFIX."fields_data` (
  `un` int(11) unsigned,
  `text` mediumtext NOT NULL,
  `int_text` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `did` int(11) unsigned,
  `data_ID` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`data_ID`),
  KEY un (`un`,`int_text`,`date`,`did`),
  KEY did (`did`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."fields_fields`; 
CREATE TABLE `".DB_PREFIX."fields_fields` (
  `field_id` int(11) unsigned,
  `name` varchar(255),
  `hely` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY field_id (`field_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."filters`; 
CREATE TABLE `".DB_PREFIX."filters` (
  `name` varchar(255) NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `data` mediumtext NOT NULL,
  `date` date NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."forms`; 
CREATE TABLE `".DB_PREFIX."forms` (
  `id` int(11) NOT NULL auto_increment,
  `form_page` varchar(64) NOT NULL,
  `g` int(11) NOT NULL,
  `form_name` varchar(255) NOT NULL,
  `form_description` text NOT NULL,
  `form_target` varchar(64) NOT NULL,
  `wizard` tinyint(1) NOT NULL,
  `wizard_steps` text NOT NULL,
  `wizard_back_button` varchar(255) NOT NULL,
  `wizard_next_button` varchar(255) NOT NULL,
  `wizard_text` text NOT NULL,
  `button_font_bold` tinyint(1) NOT NULL,
  `error_messages` text NOT NULL,
  `form_width` smallint(1) NOT NULL,
  `form_height` smallint(6) NOT NULL,
  `form_background_color` varchar(6) NOT NULL,
  `form_padding` tinyint(1) NOT NULL,
  `form_font_color` varchar(6) NOT NULL,
  `form_font_family` varchar(128) NOT NULL,
  `form_font_size` tinyint(1) NOT NULL,
  `form_font_italic` tinyint(1) NOT NULL,
  `form_font_bold` tinyint(1) NOT NULL,
  `form_radius` tinyint(1) NOT NULL,
  `form_border_color` varchar(6) NOT NULL,
  `form_border_width` tinyint(1) NOT NULL,
  `form_border_type` varchar(15) NOT NULL,
  `field_layout` varchar(15) NOT NULL,
  `field_width` smallint(1) NOT NULL,
  `field_background_color` varchar(6) NOT NULL,
  `field_radius` tinyint(1) NOT NULL,
  `field_border_color` varchar(6) NOT NULL,
  `field_border_width` tinyint(1) NOT NULL,
  `field_padding` tinyint(1) NOT NULL,
  `field_margin` tinyint(1) NOT NULL,
  `field_font_color` varchar(6) NOT NULL,
  `field_font_family` varchar(128) NOT NULL,
  `field_font_size` tinyint(1) NOT NULL,
  `field_font_italic` tinyint(1) NOT NULL,
  `field_font_bold` tinyint(1) NOT NULL,
  `button_text` varchar(255) NOT NULL,
  `button_background_color` varchar(6) NOT NULL,
  `button_radius` tinyint(1) NOT NULL,
  `button_border_color` varchar(6) NOT NULL,
  `button_border_width` tinyint(1) NOT NULL,
  `button_padding` tinyint(1) NOT NULL,
  `button_font_color` varchar(6) NOT NULL,
  `button_font_family` varchar(128) NOT NULL,
  `button_font_size` tinyint(1) NOT NULL,
  `button_font_italic` tinyint(1) NOT NULL,
  `error_van` text NOT NULL,
  `error_he` text NOT NULL,
  `error_int` text NOT NULL,
  `error_dat` text NOT NULL,
  `error_em` text NOT NULL,
  `error_nincsm` text NOT NULL,
  `last_update` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `max_subscriptions_message` text NOT NULL,
  `max_subscriptions_number` int(11),
  `subscriptions_number` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."groups`; 
CREATE TABLE `".DB_PREFIX."groups` (
  `name` varchar(255),
  `label` varchar(255),
  `h1_text` mediumtext NOT NULL,
  `h2_text` mediumtext NOT NULL,
  `h3_text` mediumtext NOT NULL,
  `h4_text` mediumtext NOT NULL,
  `h5_text` mediumtext NOT NULL,
  `h6_text` mediumtext NOT NULL,
  `h7_text` mediumtext NOT NULL,
  `sender_name` varchar(255),
  `sender_mail` varchar(255),
  `h1` varchar(255),
  `h2` varchar(255),
  `h3` varchar(255),
  `h4` varchar(255),
  `h5` varchar(255),
  `h6` varchar(255),
  `h7` varchar(255),
  `code` varchar(10),
  `stext` mediumtext NOT NULL,
  `form_back` varchar(8) NOT NULL,
  `form_border` varchar(8) NOT NULL,
  `form_text` varchar(8) NOT NULL,
  `form_button_back` varchar(8) NOT NULL,
  `form_button_border` varchar(8) NOT NULL,
  `form_button_text` varchar(8) NOT NULL,
  `form_button_text_value` varchar(255) NOT NULL,
  `form_title` varchar(255) NOT NULL,
  `op_s_up` int(11) NOT NULL,
  `op_s_down` int(11) NOT NULL,
  `op_s_amp` int(11) NOT NULL,
  `op_s_d` int(11) NOT NULL,
  `d_user` tinyint(1) NOT NULL,
  `admin_mail` varchar(1024),
  `a_up` tinyint(1) NOT NULL,
  `a_down` tinyint(1) NOT NULL,
  `a_mod` tinyint(1) NOT NULL,
  `auto_sc` text,
  `auto_del` text,
  `uns_d` tinyint(1) NOT NULL,
  `email_d` tinyint(1) NOT NULL,
  `inact` tinyint(1) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `scr_inactivate` tinyint(1) NOT NULL,
  `stat_nf` int(11) NOT NULL,
  `stat_adel` int(11) NOT NULL,
  `stat_d` int(11) NOT NULL,
  `stat_spam` int(11) NOT NULL,
  `stat_auto` int(11) NOT NULL,
  `stat_autodel` int(11) NOT NULL,
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `table_ord` tinyint(4) NOT NULL,
  `table_col_1` int(11) NOT NULL,
  `table_col_2` int(11) NOT NULL,
  `statxs` tinyint(1) unsigned NOT NULL,
  `statmail` varchar(1024) NOT NULL,
  `email_field` int(11) unsigned NOT NULL,
  `email2_field` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `h8_text` mediumtext NOT NULL,
  `h8` varchar(255),
  `hely` int(11) unsigned NOT NULL,
  `op_s_amp2` int(10) unsigned NOT NULL,
  `optin_email_html` text NOT NULL,
  `optin_email_subject` varchar(255) NOT NULL,
  `optin_form_page_html` text NOT NULL,
  `optin_params` text NOT NULL,
  `optin_success_page_html` text NOT NULL,
  `d_user_send` tinyint(1) NOT NULL,
  `bounce_account_id` int(11) NOT NULL,
  `favorite` tinyint(4),
  `h9_text` mediumtext NOT NULL,
  `h9` varchar(255),
  `uns_all_group` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."import`; 
CREATE TABLE `".DB_PREFIX."import` (
  `id` int(11) NOT NULL auto_increment,
  `g` int(11) NOT NULL,
  `pid` varchar(255) NOT NULL,
  `row` longtext NOT NULL,
  `x` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY g (`g`,`pid`,`x`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."landing_page`; 
CREATE TABLE `".DB_PREFIX."landing_page` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `code` varchar(64) NOT NULL,
  `form_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `created_at` timestamp DEFAULT current_timestamp() NOT NULL,
  `updated_at` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id_2` (`id`),
  KEY id (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."link_stat`; 
CREATE TABLE `".DB_PREFIX."link_stat` (
  `link` varchar(500) NOT NULL,
  `click` int(11) unsigned NOT NULL,
  `code` varchar(16) NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY link (`link`,`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."listing`; 
CREATE TABLE `".DB_PREFIX."listing` (
  `mid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned,
  `prior` tinyint(1) NOT NULL,
  `vid` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `stat` int(11) unsigned NOT NULL,
  `send_attempts` tinyint(4),
  PRIMARY KEY  (`id`),
  KEY mid (`mid`,`uid`,`prior`,`vid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."loginstat`; 
CREATE TABLE `".DB_PREFIX."loginstat` (
  `ip` varchar(16) NOT NULL,
  `sessid` varchar(250) NOT NULL,
  `datetime` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."messages`; 
CREATE TABLE `".DB_PREFIX."messages` (
  `name` varchar(191),
  `subject` varchar(191),
  `text` longtext,
  `sendout` int(11) NOT NULL,
  `label` varchar(191),
  `readed` int(11) NOT NULL,
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `code` varchar(40) NOT NULL,
  `al` tinyint(4) NOT NULL,
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `autosave` int(11) NOT NULL,
  `datetime` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `tiny_head` longtext NOT NULL,
  `html_only` tinyint(4) NOT NULL,
  `extract` varchar(191),
  `template_name` varchar(64) NOT NULL,
  `template_params` longtext NOT NULL,
  `spam_test` longtext,
  `utm_data` mediumtext,
  `utm` tinyint(4),
  `original_mid` int(11),
  PRIMARY KEY  (`id`),
  KEY g (`g`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."moduls`; 
CREATE TABLE `".DB_PREFIX."moduls` (
  `menu` varchar(191) NOT NULL,
  `query` varchar(255) NOT NULL,
  `inc1` varchar(255) NOT NULL,
  `inc2` varchar(255) NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."nevnap`; 
CREATE TABLE `".DB_PREFIX."nevnap` (
  `nev` varchar(255),
  `ho` tinyint(3) unsigned NOT NULL,
  `nap` tinyint(3) unsigned NOT NULL,
  `nem` tinyint(3) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."nevnap_beallitas`; 
CREATE TABLE `".DB_PREFIX."nevnap_beallitas` (
  `g` int(11) unsigned NOT NULL,
  `fmid` smallint(5) unsigned NOT NULL,
  `nmid` smallint(5) unsigned NOT NULL,
  `kid` smallint(5) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."notify`; 
CREATE TABLE `".DB_PREFIX."notify` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `url` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."poll`; 
CREATE TABLE `".DB_PREFIX."poll` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(191) NOT NULL,
  `question` text NOT NULL,
  `answers` text NOT NULL,
  `options` text,
  `status` int(11) DEFAULT '1' NOT NULL,
  `modified_at` datetime NOT NULL,
  `verify_code` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."popups`; 
CREATE TABLE `".DB_PREFIX."popups` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `hash` varchar(255) NOT NULL,
  `form_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `form_align` varchar(16) NOT NULL,
  `params` text NOT NULL,
  `g` int(11) NOT NULL,
  `last_update` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `delay` int(11) NOT NULL,
  `percent` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."send_log`; 
CREATE TABLE `".DB_PREFIX."send_log` (
  `summ` int(11) unsigned NOT NULL,
  `sendout` int(11) unsigned NOT NULL,
  `date` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `tipus` tinyint(4) NOT NULL,
  `szuro` int(11) NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `stop` tinyint(4) NOT NULL,
  `stop_date` datetime NOT NULL,
  `start_date` datetime NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  `ended` tinyint(4),
  `notify_sent` tinyint(4),
  `sending_failed` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."smails`; 
CREATE TABLE `".DB_PREFIX."smails` (
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `d` smallint(5) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `sendout` int(11) unsigned NOT NULL,
  `date` date,
  `filter` int(11) unsigned NOT NULL,
  `hour` tinyint(4) NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `field` int(11) unsigned NOT NULL,
  `operator` varchar(1) NOT NULL,
  `noyear` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."sms_listing`; 
CREATE TABLE `".DB_PREFIX."sms_listing` (
  `uid` int(11) unsigned NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `prior` tinyint(3) unsigned NOT NULL,
  `id` bigint(20) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."sms_messages`; 
CREATE TABLE `".DB_PREFIX."sms_messages` (
  `name` varchar(255),
  `text` varchar(550),
  `sendout` int(11) NOT NULL,
  `label` varchar(255) NOT NULL,
  `readed` int(11) NOT NULL,
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."sms_smails`; 
CREATE TABLE `".DB_PREFIX."sms_smails` (
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `d` smallint(5) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL,
  `sendout` int(11) unsigned NOT NULL,
  `data` text NOT NULL,
  `date` date NOT NULL,
  `filter` int(11) NOT NULL,
  `hour` tinyint(4) NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."sms_stat`; 
CREATE TABLE `".DB_PREFIX."sms_stat` (
  `uid` int(11) unsigned,
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `date` int(11) unsigned NOT NULL,
  `stat` date DEFAULT '0000-00-00' NOT NULL,
  `price` float NOT NULL,
  `type` tinyint(4) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY uid (`uid`,`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."sms_tmails`; 
CREATE TABLE `".DB_PREFIX."sms_tmails` (
  `mid` int(11) NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `filter` int(11),
  `hour` tinyint(4) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."stat`; 
CREATE TABLE `".DB_PREFIX."stat` (
  `uid` int(11) unsigned,
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `date` int(11) unsigned NOT NULL,
  `stat` date DEFAULT '0000-00-00' NOT NULL,
  `type` tinyint(4) NOT NULL,
  `D` date NOT NULL,
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `rating` tinyint(4),
  PRIMARY KEY  (`id`),
  KEY uid (`uid`,`mid`),
  KEY g (`g`,`stat`),
  KEY g_2 (`g`),
  KEY mid (`mid`),
  KEY g_3 (`g`,`date`,`stat`),
  KEY g_4 (`g`,`date`),
  KEY g_5 (`g`,`type`),
  KEY mid_2 (`mid`,`type`),
  KEY mid_3 (`mid`,`rating`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."stat_cache`; 
CREATE TABLE `".DB_PREFIX."stat_cache` (
  `date` date NOT NULL,
  `g` int(11) NOT NULL,
  `ups` mediumint(9) NOT NULL,
  `downs` mediumint(9) NOT NULL,
  `sendm` mediumint(9) NOT NULL,
  `rm` mediumint(9) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY date (`date`,`g`),
  KEY g (`g`),
  KEY date_2 (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."stat_cache_act`; 
CREATE TABLE `".DB_PREFIX."stat_cache_act` (
  `date` date NOT NULL,
  `sendout` int(11) unsigned NOT NULL,
  `read` int(11) unsigned NOT NULL,
  `link` int(11) unsigned NOT NULL,
  `act` int(11) unsigned NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."stat_cache_mail`; 
CREATE TABLE `".DB_PREFIX."stat_cache_mail` (
  `date` date NOT NULL,
  `sendout` int(11) unsigned NOT NULL,
  `read` int(11) unsigned NOT NULL,
  `link` int(11) unsigned NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY date (`date`,`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."sub_stat`; 
CREATE TABLE `".DB_PREFIX."sub_stat` (
  `date` date,
  `g` int(11),
  `c` int(11),
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY date (`date`,`g`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."survey`; 
CREATE TABLE `".DB_PREFIX."survey` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `token` varchar(15) NOT NULL,
  `title` varchar(150) NOT NULL,
  `text` text NOT NULL,
  `link` varchar(150) NOT NULL,
  `success_text` text NOT NULL,
  `modified_at` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `status` tinyint(4) DEFAULT '1' NOT NULL,
  `email_required` tinyint(4) DEFAULT '1' NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."survey_answer`; 
CREATE TABLE `".DB_PREFIX."survey_answer` (
  `id` int(11) NOT NULL auto_increment,
  `survey_id` int(11) NOT NULL,
  `email` varchar(150) NOT NULL,
  `answers` text NOT NULL,
  `date` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."survey_question`; 
CREATE TABLE `".DB_PREFIX."survey_question` (
  `id` int(11) NOT NULL auto_increment,
  `survey_id` int(11) NOT NULL,
  `question` text NOT NULL,
  `type` int(11) NOT NULL,
  `answer_assets` text NOT NULL,
  `order` int(11) NOT NULL,
  `mandatory` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."temp`; 
CREATE TABLE `".DB_PREFIX."temp` (
  `mid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned,
  `prior` tinyint(1) NOT NULL,
  `vid` smallint(5) unsigned NOT NULL,
  `stat` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."templates`; 
CREATE TABLE `".DB_PREFIX."templates` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `html_source` text NOT NULL,
  `html_head` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."tmails`; 
CREATE TABLE `".DB_PREFIX."tmails` (
  `mid` int(11) NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `filter` int(11) NOT NULL,
  `hour` tinyint(4) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  `active` tinyint(4) DEFAULT '1' NOT NULL,
  `day` smallint(5) unsigned NOT NULL,
  `month` tinyint(3) unsigned NOT NULL,
  `sent_date` date NOT NULL,
  `sent` tinyint(3) unsigned NOT NULL,
  `week` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."unscr`; 
CREATE TABLE `".DB_PREFIX."unscr` (
  `date` date DEFAULT '0000-00-00' NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `g` int(11) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY date (`date`,`g`),
  KEY mid (`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."unsubscribed`; 
CREATE TABLE `".DB_PREFIX."unsubscribed` (
  `id` int(11) NOT NULL auto_increment,
  `orig_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `group_name` varchar(128) NOT NULL,
  `mail` varchar(128) NOT NULL,
  `data` text NOT NULL,
  `meta_data` text NOT NULL,
  `status_log` text NOT NULL,
  `record_time` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."uploads`; 
CREATE TABLE `".DB_PREFIX."uploads` (
  `g` mediumint(8) unsigned NOT NULL,
  `fn` varchar(255) NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."users`; 
CREATE TABLE `".DB_PREFIX."users` (
  `mail` varchar(255) NOT NULL,
  `mail_id` int(11) unsigned NOT NULL,
  `omail` varchar(255) NOT NULL,
  `ip` varchar(45) NOT NULL,
  `datum` date DEFAULT '0000-00-00' NOT NULL,
  `ipdatum` datetime NOT NULL,
  `verify_code` varchar(50) NOT NULL,
  `active` tinyint(1),
  `g` int(11) unsigned NOT NULL,
  `a` tinyint(1) DEFAULT '1',
  `bounce` mediumint(8) unsigned NOT NULL,
  `am` tinyint(3) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `mdatum` timestamp DEFAULT '0000-00-00 00:00:00' NOT NULL on update current_timestamp(),
  `nmail` varchar(255) NOT NULL,
  `status_log` text NOT NULL,
  `ip_orig` varchar(45) NOT NULL,
  `mod_log` text NOT NULL,
  `rating` tinyint(4),
  PRIMARY KEY  (`id`),
  KEY datum (`datum`,`active`,`g`,`a`),
  KEY mail (`mail`),
  KEY mail_id (`mail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."vts`; 
CREATE TABLE `".DB_PREFIX."vts` (
  `name` varchar(255) NOT NULL,
  `g` int(11) unsigned NOT NULL,
  `a` smallint(5) unsigned NOT NULL,
  `b` smallint(5) unsigned NOT NULL,
  `db` int(11) unsigned NOT NULL,
  `f` tinyint(3) unsigned NOT NULL,
  `start` date NOT NULL,
  `end` date NOT NULL,
  `close` tinyint(3) unsigned NOT NULL,
  `date` date NOT NULL,
  `sendet` tinyint(1) NOT NULL,
  `a_name` varchar(255) NOT NULL,
  `b_name` varchar(255) NOT NULL,
  `all` int(11) unsigned NOT NULL,
  `a_send` int(11) unsigned NOT NULL,
  `b_send` int(11) unsigned NOT NULL,
  `a_read` int(11) unsigned NOT NULL,
  `b_read` int(11) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL auto_increment,
  `filter` int(11) unsigned NOT NULL,
  `hour` tinyint(3) unsigned NOT NULL,
  `listing` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `".DB_PREFIX."vts_stat`; 
CREATE TABLE `".DB_PREFIX."vts_stat` (
  `uid` int(11) unsigned NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `stat` date DEFAULT '0000-00-00' NOT NULL,
  `date` int(11) unsigned NOT NULL,
  `vtid` int(11) unsigned NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`),
  KEY vtid (`vtid`),
  KEY uid (`uid`,`vtid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

";
$change_sql = [
	"ALTER TABLE `".DB_PREFIX."messages` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;",
	"ALTER TABLE `".DB_PREFIX."messages` CHANGE subject subject VARCHAR(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;",
	"ALTER TABLE `".DB_PREFIX."messages` CHANGE label label VARCHAR(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;",
	"ALTER TABLE `".DB_PREFIX."messages` CHANGE extract extract VARCHAR(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;",
	"ALTER TABLE `".DB_PREFIX."messages` CHANGE name name VARCHAR(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;",
];

